/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.plugins;

import me.shedaniel.rei.impl.common.InternalLogger;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
@ApiStatus.Internal
public interface ReloadInterruptionContext {
    public boolean isInterrupted();

    default public void checkInterrupted() throws InterruptedException {
        if (this.isInterrupted()) {
            InternalLogger.getInstance().debug("Plugin reload interrupted!");
            throw new InterruptedException();
        }
    }

    default public ReloadInterruptionContext withJob(final Runnable ifInterrupted) {
        return new ReloadInterruptionContext(){

            @Override
            public boolean isInterrupted() {
                return ReloadInterruptionContext.this.isInterrupted();
            }

            @Override
            public void checkInterrupted() throws InterruptedException {
                try {
                    ReloadInterruptionContext.this.checkInterrupted();
                }
                catch (InterruptedException e) {
                    ifInterrupted.run();
                    throw e;
                }
            }
        };
    }

    public static ReloadInterruptionContext ofNever() {
        return () -> false;
    }
}

